/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.attack;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.constants.AiMutex;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.reflection.entity.ai.EntityAITasksReflection;

public class EntityAICustom
extends EntityAIBase {
    protected final EntityNPCInterface npc;
    protected final int tickRate;
    protected EntityLivingBase target;
    public boolean hasAttack;
    public boolean startRangedAttack;
    public boolean isRanged;
    public boolean canSeeToAttack;
    public boolean inMove;
    public boolean isFriend;
    protected int burstCount;
    protected int tacticalRange;
    protected int rangedTick;
    protected int meleeTick;
    protected int step;
    public double distance;
    public double range;

    public EntityAICustom(EntityNPCInterface npc) {
        this.npc = npc;
        this.navOverride(true);
        this.tickRate = EntityAITasksReflection.getTickRate(npc.field_70714_bg);
        this.step = 0;
        this.distance = -1.0;
    }

    public EntityAICustom(IRangedAttackMob npcIn) {
        if (!(npcIn instanceof EntityNPCInterface)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.npc = (EntityNPCInterface)npcIn;
        this.navOverride(true);
        this.tickRate = EntityAITasksReflection.getTickRate(this.npc.field_70714_bg);
        this.distance = -1.0;
    }

    public EntityLivingBase getTarget() {
        return this.target;
    }

    public void navOverride(boolean nav) {
        this.func_75248_a(nav ? AiMutex.PATHING : AiMutex.LOOK + AiMutex.PASSIVE);
    }

    public void func_75251_c() {
        this.canSeeToAttack = false;
        this.npc.updateHitbox();
    }

    public boolean func_75253_b() {
        return this.npc != null && this.npc.func_70089_S() && this.setTarget();
    }

    private boolean setTarget() {
        this.target = this.npc.func_70638_az();
        if (this.npc.aiOwnerNPC != null && this.npc.aiOwnerNPC.func_70089_S()) {
            EntityLivingBase ownerTarget = this.npc.aiOwnerNPC.func_70638_az();
            if (ownerTarget != null && ownerTarget.equals((Object)this.target)) {
                this.npc.func_70624_b(ownerTarget);
            }
            this.target = this.npc.func_70638_az();
        }
        if (this.target == null || !this.target.func_70089_S()) {
            this.startRangedAttack = false;
            return false;
        }
        this.isFriend = this.npc.isFriend((Entity)this.target);
        return this.target != null;
    }

    public boolean func_75250_a() {
        CustomNpcs.debugData.start((Object)this.npc);
        this.distance = -1.0;
        this.canSeeToAttack = false;
        this.hasAttack = false;
        this.setTarget();
        CustomNpcs.debugData.end((Object)this.npc);
        return this.setTarget();
    }

    protected void tryMoveToTarget() {
        if (!CustomNpcs.ShowCustomAnimation || !this.npc.animation.isAnimated(AnimationKind.ATTACKING, AnimationKind.INIT, AnimationKind.INTERACT, AnimationKind.DIES)) {
            double dist;
            double speed;
            double baseSpeed;
            double d = baseSpeed = this.npc.ais.canSprint ? 1.5 : 1.3;
            if (this.target.equals((Object)this.npc.combatHandler.priorityTarget)) {
                double d2 = baseSpeed = this.npc.ais.canSprint ? 1.6 : 1.4;
            }
            if ((speed = (0.75 / (double)this.npc.stats.aggroRange * (dist = this.npc.func_70011_f(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v)) + 0.5) * baseSpeed) < 1.3) {
                speed = 1.3;
            } else if (speed > baseSpeed) {
                speed = baseSpeed;
            }
            this.npc.func_70661_as().func_75497_a((Entity)this.target, speed);
        }
    }

    protected void tryToCauseDamage() {
        if (this.isRanged) {
            if (this.rangedTick > 0 || this.distance > this.range || !this.canSeeToAttack || this.npc.stats.ranged.getFireType() == 2) {
                if (this.rangedTick == 0 && !this.canSeeToAttack) {
                    this.rangedTick = 5;
                }
                this.startRangedAttack = false;
                return;
            }
            this.startRangedAttack = true;
            return;
        }
        if (this.meleeTick > 0 || this.distance > this.range || !this.canSeeToAttack) {
            if (this.meleeTick == 0 && !this.canSeeToAttack) {
                this.meleeTick = 5;
            }
            return;
        }
        this.meleeTick = this.npc.stats.melee.getDelayRNG();
        this.npc.func_184609_a(EnumHand.MAIN_HAND);
        this.npc.func_70652_k((Entity)this.target);
        this.hasAttack = true;
    }

    public void update() {
        CustomNpcs.debugData.start((Object)this.npc);
        if (!(this.startRangedAttack && this.target != null && this.target.func_70089_S() && this.npc.func_70089_S())) {
            this.startRangedAttack = false;
            CustomNpcs.debugData.end((Object)this.npc);
            return;
        }
        ++this.step;
        if (this.step >= this.tickRate) {
            this.step = 0;
        }
        if (this.rangedTick > this.step) {
            return;
        }
        if (this.burstCount++ <= this.npc.stats.ranged.getBurst()) {
            this.rangedTick = this.npc.stats.ranged.getBurstDelay();
        } else {
            this.burstCount = 0;
            this.hasAttack = true;
            this.rangedTick = this.npc.stats.ranged.getDelayRNG();
        }
        if (this.burstCount > 1) {
            boolean indirect = false;
            switch (this.npc.stats.ranged.getFireType()) {
                case 1: {
                    indirect = this.distance > this.range / 2.0;
                    break;
                }
                case 2: {
                    indirect = !this.npc.func_70635_at().func_75522_a((Entity)this.target);
                }
            }
            this.npc.func_82196_d(this.target, indirect ? 1.0f : 0.0f);
            if (this.npc.currentAnimation != 6) {
                this.npc.func_184609_a(EnumHand.MAIN_HAND);
            }
            this.step = 0;
        }
        CustomNpcs.debugData.end((Object)this.npc);
    }

    public void func_75246_d() {
        CustomNpcs.debugData.start((Object)this.npc);
        this.inMove = !this.npc.func_70661_as().func_75500_f();
        this.tacticalRange = this.npc.ais.getTacticalRange();
        this.distance = this.npc.func_70011_f(this.target.field_70165_t, this.target.func_174813_aQ().field_72338_b, this.target.field_70161_v);
        boolean bl = this.isRanged = this.npc.inventory.getProjectile() != null && (this.npc.stats.ranged.getMeleeRange() <= 0 || this.distance > (double)this.npc.stats.ranged.getMeleeRange());
        if (this.isRanged) {
            --this.rangedTick;
            this.range = this.npc.stats.ranged.getRange();
        } else {
            --this.meleeTick;
            this.range = this.npc.stats.melee.getRange();
            double minRange = (double)(this.npc.field_70130_N + this.target.field_70130_N) / 2.0;
            if (minRange > this.range) {
                this.range = minRange;
            }
        }
        CustomNpcs.debugData.end((Object)this.npc);
    }

    public void writeToClientNBT(NBTTagCompound compound) {
    }
}

